{smcl}
{* *! version 1.0.0, 25aug2014}{...}
{title:Title}

{phang}
{bf:svarih {hline 2}} Structural vector autoregressive models, identified through heteroskedasticity


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:svarih} {it:method} {depvarlist} {ifin} [{cmd:,} {it:options}]

{synoptset 22}{...}
{synopthdr:method}
{synoptline}
{synopt:{opt bac:chiocchi}}{help svarih##B2011:Bacchiocchi (2011)} method and model{p_end}
{synopt:{opt bfa:nelli}}{help svarih##BF2012:Bacchiocchi/Fanelli (2012)} method and model{p_end}
{synopt:{opt llu:tkepohl}}{help svarih##LL2008:Lanne/Ltkepohl (2008)} method and model{p_end}
{synoptline}

{p 4 6 2}
For the detailed syntax and description of these estimation methods, see {help svarih bac}, {help svarih bfa} and {help svarih llu}.


{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih} implements several identification methods and models for structural vector autoregressions that are based on identification through heteroskedasticity.
For a detailed exposition of these estimation methods, see their respective help files.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation}

{pstd}
The following list contains abbreviations, definitions, and notation that are used throughout this help file, the help files for {cmd:svarih} methods, and for {cmd:dsimih} and {cmd:dsimih} subcommands.

{p2colset 5 36 36 0}{...}
{p2col:Definitions:}{p_end}
{p2col:volatility regime/state}period of time within which the structural / reduced-form covariance matrix does not change.{p_end}
{p2col:regime variable}categorical numeric variable that identifies volatility regimes{p_end}
{p2col:regime matrix}matrix that pins down the volatile shocks for each volatility state{p_end}
{p2col:}{p_end}
{p2col:Abbreviations:}{p_end}
{p2col:IH}identification through heteroskedasticity{p_end}
{p2col:IH-BAC}IH, Bacchiocchi (2011) method{p_end}
{p2col:IH-BFA}IH, Bacchiocchi/Fanelli (2012) method{p_end}
{p2col:IH-LLU}IH, Lanne/Ltkepohl (2008) method{p_end}
{p2col:(S)VAR}(structural) vector autoregression{p_end}
{p2col:SIRF}structural impulse response function{p_end}
{p2col:SFEVD}structural forecast-error variance decomposition{p_end}


{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help svarih##svarihmodels:Structural VAR IH models}
    {help svarih##variantsofihmodels:Variants of IH models}
    {help svarih##notation:Notation}
    {help svarih##helpfileaccess:Help file access}


{marker svarihmodels}{...}
{title:Structural VAR IH models}

{pstd}
Structural VAR estimation has a long tradition in economics.
Various methods have been proposed to identify the parameters of a structural VAR simultaneous equations model, the most prominent ones being short-run (exclusion/equality) restrictions, long-run restrictions, and sign restrictions.
{help svarih##K2011:Kilian (2011)} provides an excellent overview of the identification methods that have been advanced.
Identification through short-run and long-run restrictions have been implemented in official Stata through the {help svar} command.

{pstd}
{cmd:svarih}, by contrast, uses identification methods that are based on heteroskedasticity in the data.
It posits the existence of different "regimes".
This means that the covariance matrix of the structural (as well as the reduced-form) shocks varies over time but remains constant within a certain time span ("regime").
In practice, this often translates into defining a "baseline" regime and one or several "volatility" regimes that deviate from the baseline.
Each regime can occur multiple times.
The sequence of regimes is unrestricted.
There can be gaps in the data.

{pstd}
Apart from the existence of different error covariance matrices, the model employed fully corresponds to the standard structural VAR model.
In particular, this means that the A-matrix and/or the B-matrix (in AB-model notation; see {mansection TS varsvar:[TS] svar} (manual) and {help svar} (online)), if they are present in the respective SVAR-IH model, contain constant coefficients.

{pstd}
IH models achieve identification through positing a priori knowledge about the changing nature of structural shocks, i.e. different volatility regimes.
The applicability of IH models thus depends on the plausibility of such assumptions.
The advantage of these identification methods is that apart from normalization restrictions no or fewer constraints on the parameters to be estimated are necessary, or that constraints can be imposed in a more flexible way.

{pstd}
Since IH models assume different states of volatility, you have to supply the estimation command with information regarding the different volatility periods.
All {cmd:svarih} methods take a variable as input that identifies the regimes.
{help svarih bacchiocchi} additionally needs a matrix that tells the estimation routine which shocks have modified volatility during each volatility regime.

{pstd}
After estimation, you can use {help dsimih} to create SIRFs and SFEVDs.
{cmd:predict} generates prediced values, residuals, shocks, and historical decompositions.
For these and other postestimation tools, see {help svarih postestimation}.

{marker variantsofihmodels}{...}
{title:Variants of IH models}

{pstd}
The seminal contribution in the IH SVAR literature is {help svarih##R2003:Rigobon (2003)}.
It consists of an A-model where shock volatility regimes are defined exogenously.
To account for correlatedness of the structural shocks, common shocks can be added to the model.
There is no asymptotic framework.
Standard errors are obtained through a bootstrap.
{help svarih##LL2008:Lanne and Ltkepohl (2008)} converted the model to a B-model and added an asymptotic ML framework.
{help svarih##LL2010:Lanne and Ltkepohl (2010)} set up a similar B-model that models the residuals as following a mixture normal distribution.
{help svarih##LLM2010:Lanne et al. (2010)} add Markov-switching properties to a B-model so that regimes are determined endogenously.
{help svarih##B2011:Bacchiocchi (2011)} provides an AB-model ML framework that also allows for different shock propagation in different regimes.
Finally, {help svarih##BF2012:Bacchiocchi and Fanelli (2012)} tackle the issue of simultaneous changes in volatility and B-matrix elements.
For a survey of these and similar methods, see {help svarih##L2012:Ltkepohl (2012)}.


{marker Notation}{...}
{title:Notation}

{pstd}
The usage of conflicting notation for VAR and SVAR related model parameters in different publications is an obstacle in understanding and comparing the different methods.
To facilitate the understanding of the differenet IH methods and how they compare to the standard {cmd:svar} methods, 
the notation of {cmd:svarih} leans heavily on the Stata time-series manual entries of {help var} and {help svar}.
Notation matters in some instances for command options and for returned {cmd:e()}-values but mostly for the accompanying PDF document on methods and formulas.

{marker helpfileaccess}{...}
{title:Help file access}

{pstd}
The help files for the subcommands of {cmd:svarih} are available under their minimum abbreviated form.
For example, type "{input:help svarih bac}" instead of "{input:help svarih bacchiocchi}".
Likewise, the other estimation subcommand help files are accessible under "{input:svarih bfa}" and "{input:svarih llu}".
Help for the postestimation option "{cmd:svarih, cmat}" is available under "{input:help svarih cmat}".
Help for the utility {cmd:svarih examples} which generate example estimates can be accessed by "{input:help svarih examples}".

{pstd}
A PDF document called {cmd:svarihMethodsAndFormulas.pdf} that details methods and formulas used in {cmd:svarih} and {cmd:dsimih} is part of the {cmd:svarih} package.
During package installation the PDF file is copied into the same directory as {cmd:svarih.ado}.
To find the directory where both files are located, you can type

{pmore}
{cmd:. findfile svarih.ado , all}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker citation}{...}
{title:Citation}

{phang}
{cmd:svarih} is not an official Stata command. It is a free contribution to the research community, like a paper. Please cite it as such:

{phang}
Schneider, Daniel C. (2014): svarih: Stata Module to Estimate and Analyze Structural VAR Models Based on Selected Methods of Identification through Heteroskedasticity. Downloadable from http://www.dan-schneider.net/stata.


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
The code of official Stata's {cmd:svar} has served as a point of reference throughout the development of {cmd:svarih}.
Any remaining errors in {cmd:svarih} are mine.


{marker disclaimer}{...}
{title:DISCLAIMER}

{pstd}
THE SVARIH STATA PACKAGE (THE "SOFTWARE") COMES AS-IS.
NO WARRANTIES, EXPRESS OR IMPLIED, ARE GIVEN.
ANY CONSEQUENTIAL DAMAGE DUE TO THE USE OF THE SOFTWARE IS THE SOLE
RESPONSIBILITY OF THE USER.


{marker references}{...}
{title:References}

{marker B2011}{...}
{phang}
Bacchiocchi, E. (2011): Identification in Structural VAR Models with Different Volatility Regimes.
Universita Degli Studi di Milano, Working Paper No.2011-39.

{marker BF2012}{...}
{phang}
Bacchiocchi, E. and L. Fanelli (2012): Identification in Structural Vector Autoregressive Models with Structural Changes.
Universita Degli Studi di Milano, Working Paper No.2012-16.

{marker K2011}{...}
{phang}
Kilian, L. 2011. Structural Vector Autoregressions.
Working Paper, University of Michigan.

{marker LL2008}{...}
{phang}
Lanne, M. and H. Ltkepohl (2008): Identifying Monetary Policy Shocks via Changes in Volatility.
{it:Journal of Money, Credit and Banking}, 40 (6), 1131-1149.

{marker LL2010}{...}
{phang}
Lanne, M. and H. Ltkepohl (2010): Structural Vector Autoregressions with Nonnormal Residuals.
{it:Journal of Business and Economic Statistics}, 28, 159-168.

{marker LLM2010}{...}
{phang}
Lanne, M., Ltkepohl, H. and K. Maciejowska (2010): Structural Vector Autoregressions with Markov Switching.
{it:Journal of Economic Dynamics and Control}, 34, 121-131.

{marker L2012}{...}
{phang}
Ltkepohl, H. (2012): Identifying Structural Vector Autoregressions via Changes in Volatility. 
DIW Discussion Papers No.1259.

{marker R2003}{...}
{phang}
Rigobon, R. (2003). Identification through Heteroskedasticity.
{it:The Review of Economics and Statistics} 85(4): 777-792.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih bac},
{helpb svarih bfa},
{helpb svarih llu},
{helpb svarih postestimation},
{helpb svarih cmat},
{helpb dsimih}
{p_end}

